#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
//#include "hidclass.h"
#include <sysutils.hpp> //Win32Check()

#define bufferLength 126

#define HID_CTL_CODE(id) \
  CTL_CODE (FILE_DEVICE_KEYBOARD, (id), METHOD_NEITHER, FILE_ANY_ACCESS)
#define HID_BUFFER_CTL_CODE(id) \
  CTL_CODE (FILE_DEVICE_KEYBOARD, (id), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HID_IN_CTL_CODE(id) \
  CTL_CODE (FILE_DEVICE_KEYBOARD, (id), METHOD_IN_DIRECT, FILE_ANY_ACCESS)
#define HID_OUT_CTL_CODE(id) \
  CTL_CODE (FILE_DEVICE_KEYBOARD, (id), METHOD_OUT_DIRECT, FILE_ANY_ACCESS)


#define IOCTL_GET_PHYSICAL_DESCRIPTOR         HID_OUT_CTL_CODE(102)
#define IOCTL_HID_FLUSH_QUEUE                 HID_CTL_CODE(101)
#define IOCTL_HID_GET_COLLECTION_DESCRIPTOR   HID_CTL_CODE(100)
#define IOCTL_HID_GET_COLLECTION_INFORMATION  HID_BUFFER_CTL_CODE(106)
#define IOCTL_HID_GET_FEATURE                 HID_OUT_CTL_CODE(100)
#define IOCTL_HID_GET_HARDWARE_ID             HID_OUT_CTL_CODE(103)
#define IOCTL_HID_GET_INDEXED_STRING          HID_OUT_CTL_CODE(120)
#define IOCTL_HID_GET_INPUT_REPORT            HID_OUT_CTL_CODE(104)
#define IOCTL_HID_GET_MANUFACTURER_STRING     HID_OUT_CTL_CODE(110)
#define IOCTL_GET_NUM_DEVICE_INPUT_BUFFERS    HID_BUFFER_CTL_CODE(104)
#define IOCTL_HID_GET_POLL_FREQUENCY_MSEC     HID_BUFFER_CTL_CODE(102)
#define IOCTL_HID_GET_PRODUCT_STRING          HID_OUT_CTL_CODE(111)
#define IOCTL_HID_GET_SERIALNUMBER_STRING     HID_OUT_CTL_CODE(112)
#define IOCTL_HID_SET_FEATURE                 HID_IN_CTL_CODE(100)
#define IOCTL_SET_NUM_DEVICE_INPUT_BUFFERS    HID_BUFFER_CTL_CODE(105)
#define IOCTL_HID_SET_OUTPUT_REPORT           HID_IN_CTL_CODE(101)
#define IOCTL_HID_SET_POLL_FREQUENCY_MSEC     HID_BUFFER_CTL_CODE(103)

#define IOCTL_HID_GET_DRIVER_CONFIG           HID_BUFFER_CTL_CODE(100)
#define IOCTL_HID_SET_DRIVER_CONFIG           HID_BUFFER_CTL_CODE(101)
#define IOCTL_HID_GET_MS_GENRE_DESCRIPTOR     HID_OUT_CTL_CODE(121)

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
DWORD requiredSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
//---------------------------------------------------------
typedef struct _HIDD_ATTRIBUTES
  {
    ULONG Size;
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;
//---------------------------------------------------------
typedef struct _HID_COLLECTION_INFORMATION { //hidclass.h
    ULONG DescriptorSize;
    BOOLEAN Polled;
    UCHAR Reserved1[1];
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HID_COLLECTION_INFORMATION, *PHID_COLLECTION_INFORMATION;
//---------------------------------------------------------
HANDLE  hidDeviceObject;
HIDD_ATTRIBUTES hiddAttributes;
HID_COLLECTION_INFORMATION collectionInformation;
wchar_t buffer[bufferLength];
DWORD lpBytesReturned = 0;
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
PHIDP_PREPARSED_DATA preparsedData;

typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;

HIDP_CAPS capabilities;
//---------------------------------------------------------
int main()
{

   long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);

   void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

   hHidLib = LoadLibrary("HID.DLL");
   if (!hHidLib)
     displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
   (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib, "HidP_GetCaps");

   if (!HidD_GetHidGuid || !HidP_GetCaps){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
       FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
   hiddAttributes.Size = sizeof(HIDD_ATTRIBUTES);


   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            &requiredSize, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                  GENERIC_READ | GENERIC_READ,
                                  FILE_SHARE_READ | FILE_SHARE_WRITE,
                                  NULL, OPEN_EXISTING, 0, NULL );
       if(hidDeviceObject != INVALID_HANDLE_VALUE) {
          //cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";

          DeviceIoControl(hidDeviceObject, IOCTL_HID_GET_MANUFACTURER_STRING,
                          NULL,0,buffer,sizeof(buffer),&lpBytesReturned, NULL);
          printf("Producent = %ls\n", buffer);

          DeviceIoControl(hidDeviceObject, IOCTL_HID_GET_COLLECTION_INFORMATION,
                          NULL,0,&collectionInformation,
                          sizeof(HID_COLLECTION_INFORMATION),
                          &lpBytesReturned, NULL);
          hiddAttributes.VendorID = collectionInformation.VendorID;
          hiddAttributes.ProductID = collectionInformation.ProductID;
          hiddAttributes.VersionNumber = collectionInformation.VersionNumber;
          printf("VID/PID/wersja = %x/%x/%x\n",hiddAttributes.VendorID,
                                               hiddAttributes.ProductID,
                                               hiddAttributes.VersionNumber);

         /*if(!DeviceIoControl(hidDeviceObject, IOCTL_HID_GET_COLLECTION_INFORMATION,
                             NULL,0,&collectionInformation,
                             sizeof(HID_COLLECTION_INFORMATION),
                             &lpBytesReturned, NULL))
            break;
         */
         preparsedData = (PHIDP_PREPARSED_DATA)\
                          new DWORD[collectionInformation.DescriptorSize];

         DeviceIoControl(hidDeviceObject, IOCTL_HID_GET_COLLECTION_DESCRIPTOR,
                         NULL,0,preparsedData,collectionInformation.DescriptorSize,
                         &lpBytesReturned, NULL);

         HidP_GetCaps(preparsedData, &capabilities);
         printf("Usage=%x\nUsagePage=%x\nInputReportByteLength=%d\n"
                "OutputReportByteLength=%d\nFeatureReportByteLength=%d\n"
                "NumberLinkCollectionNodes=%d\n"
                "NumberInputButtonCaps=%d\nNumberInputValueCaps=%d\n\n",
                capabilities.Usage, capabilities.UsagePage,
                capabilities.InputReportByteLength,
                capabilities.OutputReportByteLength,
                capabilities.FeatureReportByteLength,
                capabilities.NumberLinkCollectionNodes,
                capabilities.NumberInputButtonCaps,
                capabilities.NumberInputValueCaps);


          releaseMemory(preparsedData);
          Win32Check(CloseHandle(hidDeviceObject));
       }
       releaseMemory(deviceInterfaceDetailData);
    };//koniec while

   //Win32Check(CloseHandle(hidDeviceObject));
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

